
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1011.C - Message 1011 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1011 messages.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\MSG1011.C_V  $
//   
//      Rev 1.15   09 Nov 1998 10:47:46   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.3   Jul 09 1997 10:38:52   COLEJ
//    
//   
//      Rev 1.2   Feb 12 1997 16:05:18   COLEJ
//    
//   
//      Rev 1.1   Aug 14 1996 09:37:36   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:52:46   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1011 message from the ZMsgBuf.
//
void Dec1011(tMSGBUF *ZMsgBuf, tMSG1011 *Msg)
{
   tSHORT i;

   GetShort  (&Msg->SequenceNumber          , ZMsgBuf, 8);     // ND   
   
   for(i=0; i<10; i++){
   GetChar   (&Msg->NumberOfChannels[i*2]   , ZMsgBuf, 9+ i, 0);  // char data
   GetChar   (&Msg->NumberOfChannels[i*2+1] , ZMsgBuf, 9+ i, 1);  // char data
   GetChar   (&Msg->SoftwareVersion[i*2]    , ZMsgBuf,19+ i, 0);  // char data
   GetChar   (&Msg->SoftwareVersion[i*2+1]  , ZMsgBuf,19+ i, 1);  // char data
   GetChar   (&Msg->SoftwareDate[i*2]       , ZMsgBuf,29+ i, 0);  // char data
   GetChar   (&Msg->SoftwareDate[i*2+1]     , ZMsgBuf,29+ i, 1);  // char data
   GetChar   (&Msg->OptionsList[i*2]        , ZMsgBuf,39+ i, 0);  // char data
   GetChar   (&Msg->OptionsList[i*2+1]      , ZMsgBuf,39+ i, 1);  // char data
   }
}                                      
                                     
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1011 message in the ZMsgBuf. 
//
void Bld1011(tMSGBUF *ZMsgBuf, tMSG1011 *Msg)
{
   tSHORT i;

   // ack flags assumed preset

   PutShort  (0x81FF                        , ZMsgBuf, 1);     // message preamble
   PutShort  (1011                          , ZMsgBuf, 2);     // message number
   PutShort  (15                            , ZMsgBuf, 3);     // message length 
   PutShort  (ANREQ                         , ZMsgBuf, 4);     // message ack/nack request
 //PutShort  (CheckSum(ZMsgBuf[0], 4)       , ZMsgBuf, 5);     // header check sum
                                                  
   PutShort  (Msg->SequenceNumber           , ZMsgBuf, 8);     // ND  
   
   for(i=0; i<10; i++){
   PutChar   (Msg->NumberOfChannels[i*2]    , ZMsgBuf, 9+ i, 0);  // char data
   PutChar   (Msg->NumberOfChannels[i*2+1]  , ZMsgBuf, 9+ i, 1);  // char data
   PutChar   (Msg->SoftwareVersion[i*2]     , ZMsgBuf,19+ i, 0);  // char data
   PutChar   (Msg->SoftwareVersion[i*2+1]   , ZMsgBuf,19+ i, 1);  // char data
   PutChar   (Msg->SoftwareDate[i*2]        , ZMsgBuf,29+ i, 0);  // char data
   PutChar   (Msg->SoftwareDate[i*2+1]      , ZMsgBuf,29+ i, 1);  // char data
   PutChar   (Msg->OptionsList[i*2]         , ZMsgBuf,39+ i, 0);  // char data
   PutChar   (Msg->OptionsList[i*2+1]       , ZMsgBuf,39+ i, 1);  // char data
   }
 //PutShort  (CheckSum(ZMsgBuf, 6, 9)       , ZMsgBuf, 13);    // data check sum 
}

////////////////////////////////////////////////////////////////////////////////
//   
//   Display a Zodiac 1011 message from the ZMsgBuf.
//
void Show1011(tMSG1011 *Msg)
{
   char    Buf[80] = "";

   // perform special processing for output
   sprintf(Buf,"RECEIVER CHANNELS: %s  SW VERSION: %s  SW DATE: %s  SW OPTIONS: %s",
           Msg->NumberOfChannels, Msg->SoftwareVersion,
           Msg->SoftwareDate, Msg->OptionsList);

   // output the data items                                                                                                  
   ShowText(Buf,CMDR   ,CMDC   );
}                                                 
                                      
                                           
